#pragma once

#include <functional>
#include <list>
#include <string>
#include <cassert>

class Type;
class Value;
class User;
struct Use;

class Value {
  public:
	Value(const Value& other) = delete;
	Value(Value&& other) noexcept = delete;
	Value& operator=(const Value& other) = delete;
	Value& operator=(Value&& other) noexcept = delete;

	explicit Value(Type *ty, std::string name = "")
        : type_(ty), name_(std::move(name)){}
    virtual ~Value();

    std::string get_name() const { return name_; }
    Type *get_type() const { return type_; }
    const std::list<Use> &get_use_list() const { return use_list_; }

    bool set_name(const std::string& name);

    void add_use(User *user, unsigned arg_no);
    void remove_use(User *user, unsigned arg_no);

    void replace_all_use_with(Value *new_val) const;
    void replace_use_with_if(Value *new_val, const std::function<bool(Use *)>& should_replace);

    virtual std::string print() = 0;

    template<typename T>
    T *as()
    {
      static_assert(std::is_base_of_v<Value, T>, "T must be a subclass of Value");
      const auto ptr = dynamic_cast<T*>(this);
      assert(ptr && "dynamic_cast failed");
      return ptr;
    }
    template<typename T>
    const T* as() const {
        static_assert(std::is_base_of_v<Value, T>, "T must be a subclass of Value");
        const auto ptr = dynamic_cast<const T*>(this);
        assert(ptr);
        return ptr;
    }
    // is 接口
    template <typename T>
    bool is() const {
        static_assert(std::is_base_of_v<Value, T>, "T must be a subclass of Value");
        return dynamic_cast<const T*>(this);
    }

    // 用于 lldb 调试生成 summary
    std::string safe_get_name_or_ptr() const;
  private:
    Type *type_;
    std::list<Use> use_list_; // who use this value
    std::string name_;        // should we put name field here ?
};
