#include "GlobalVariable.hpp"
#include "IRprinter.hpp"
#include "Module.hpp"

GlobalVariable::GlobalVariable(const std::string& name, Module *m, Type *ty,
                               bool is_const, Constant *init)
    : User(ty, name), is_const_(is_const), init_val_(init) {
    m->add_global_variable(this);
    if (init) {
        this->add_operand(init);
    }
} // global操作数为initval

std::string GlobalVariable::safe_print() const
{
    std::string ret;
    if (is_const_) ret += "const ";
    auto ty = get_type();
    if (ty == nullptr) ret += "<null> ";
    else ret += ty->safe_print() + " ";
    ret += get_name();
    if (init_val_ != nullptr) ret += " " + init_val_->safe_print_help();
    return ret;
}

GlobalVariable *GlobalVariable::create(const std::string& name, Module *m, Type *ty,
                                       bool is_const,
                                       Constant *init = nullptr) {
    return new GlobalVariable(name, m, PointerType::get(ty), is_const, init);
}

std::string GlobalVariable::print() {
    std::string global_val_ir;
    global_val_ir += print_as_op(this, false);
    global_val_ir += " = ";
    global_val_ir += (this->is_const() ? "constant " : "global ");
    global_val_ir += this->get_type()->get_pointer_element_type()->print();
    global_val_ir += " ";
    global_val_ir += this->get_init()->print();
    return global_val_ir;
}
